setwd("---")

library(devtools)
library(viridis)
library(dplyr)
library(tibble)
library(tidyverse)
library(colormap)
library(FactoMineR)
library(factoextra)
library(ggfortify)
library(plotly)
library(RColorBrewer)

orig_df <- read.csv(file="hypts_EBGM_hlt.csv", header=T, sep="$")

### pulmonary
pulm_ade_df <- read.csv(file = 'pulm_meddra_hypts.csv', header=T, sep="$")
pulm_ade <- toupper(unique(pulm_ade_df$hlt))
### delete five ADEs which are less related
pulm_ade <- pulm_ade[-c(1, 8,17,18,26)]
# write.table(pulm_ade, 'final_30_pulm_hlt.csv', sep = "\t")

### different drug names
glasso_drugs <- c("ACEBUTOLOL","ALISKIREN","ALTHIAZIDE\\SPIRONOLACTONE",
                  "AMLODIPINE\\HYDROCHLOROTHIAZIDE\\OLMESARTAN","AMLODIPINE\\OLMESARTAN","AZELNIDIPINE",
                  "AZELNIDIPINE\\OLMESARTAN","BENIDIPINE","BOSENTAN",
                  "CANDESARTANCILEXETIL\\HYDROCHLOROTHIAZIDE","CELIPROLOL","CILAZAPRIL",
                  "CILNIDIPINE","DIHYDRALAZINE","EPOPROSTENOL",
                  "HYDROCHLOROTHIAZIDE\\OLMESARTAN","ILOPROST","IMIDAPRIL",
                  "IRBESARTAN","LABETALOL","MACITENTAN",
                  "METHYLDOPA","NIFEDIPINE","NILVADIPINE",
                  "OLMESARTAN","QUINAPRIL","RILMENIDINE",
                  "RIOCIGUAT","SELEXIPAG","SIMVASTATIN",
                  "URAPIDIL", "XIPAMIDE")

df_N <- orig_df %>%
  filter(var2 %in% pulm_ade) %>%
  mutate(E=log(E)) %>%
  select(var1, var2, E) %>%
  spread(var1, E) %>%
  replace(is.na(.), 0)

hlt_25 <- orig_df %>% filter(var2 %in% pulm_ade)
hlt_25 <- unique(hlt_25$var2)
hlt_25 <- toupper(hlt_25)

pt_in_hlt <- pulm_ade_df %>% filter(toupper(hlt) %in% hlt_25)

df_N_1 <- as.data.frame(t(df_N[,-1]))
colnames(df_N_1) <- df_N$var2

### color
df <- as.data.frame(df_N_1)
df_N_1$color <- viridis(length(rownames(df)), alpha = 1, begin = 0, end = 1, option = "D")
df_N_1 <- tibble::rownames_to_column(df_N_1, "Drug")

### PCA
dim(df_N_1)
df_1 <- df_N_1[,2:(dim(df_N_1)[2]-1)]
rownames(df_1) <- df_N_1$Drug

###################
### loading and ind
df_N_1.pca <- prcomp(df_1, scale = F, center = T)

### PCA plot Center = T
df_N_1.pca <- PCA(df_1, scale.unit = F, graph = FALSE)
# print(df_N_1.pca)
eig.val <- get_eigenvalue(df_N_1.pca)

fviz_eig(df_N_1.pca, addlabels = TRUE, ylim = c(0, 50))
ind <- get_pca_ind(df_N_1.pca)
coord_ind <- as.data.frame(ind$coord[,1:3])
var <- get_pca_var(df_N_1.pca)

contrib_var <- as.data.frame(var$contrib[,1:3])
contrib_var <- contrib_var %>%
                   arrange(-Dim.1)
# write.table(contrib_var, 'contrib_pc123_logE.csv', sep ="\t")

### 2D PCA plot
fviz_pca_biplot(df_N_1.pca, 
                # Fill individuals by groups
                pointshape = 22,
                pointsize = 2,
                labl = "ind",
                labelsize = 3,
                fill.ind = df_N_1$Drug,
                col.ind = "black",
                axes = c(1, 2),
                repel = F        # Avoid label overplotting
) +
  theme(
    text = element_text(size = 25),
    axis.text = element_text(size = 25),
    panel.grid.major=element_blank(),
    panel.grid.minor=element_blank(),
    legend.position="none") +
  ggpubr::fill_palette("viridis") + 
  xlab("PC1 (87.9%)") +
  ylab("PC2 (3.4%)") + 
  ggtitle(label='') 

### 3D PCA plot
# Get principal component vectors using prcomp instead of princomp
### drug group
drug_class <- read.csv('hypts_134_drugs.csv', sep = ',')
colnames(drug_class) <- c('Drug', 'ATC')

pc <- prcomp(df_1, scale. = F, center = T)
pc$rotation[,1:7]
comp <- data.frame(pc$x[,1:7])

idcomp <- data.frame(cbind(df_N_1[,c('Drug', 'color')], comp))
idcomp <- idcomp %>%
            left_join(drug_class, by = 'Drug')

mycolor <- colormap(colormap=colormaps$hsv, nshades = length(unique(idcomp$ATC)))
mycolor <- c("#00FFFF","#00FF00","#FFFF00","#800080","#FF00FF","#FF0000","#0000FF","#800000","#808080","#000000","#008080","#FA8072")

mtpinfo <- plot_ly(idcomp, x = ~PC1, y = ~PC2, z = ~PC3, 
                   color = ~ATC,
                   colors = mycolor,
                   text = ~paste('Drug:', Drug)) %>%
                       add_markers() %>%
                          layout(scene = list(xaxis = list(title = 'PC1'), 
                                              yaxis = list(title = 'PC2'), 
                                              zaxis = list(title = 'PC3'))) %>% 
                          layout(plot_bgcolor='rgb(255,255,255)') %>%
                          layout(paper_bgcolor='rgb(255,255,255)')
mtpinfo
